package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTuneOptions(
    desiredState: Optional[zio.aws.opensearch.model.AutoTuneDesiredState] =
      Optional.Absent,
    rollbackOnDisable: Optional[zio.aws.opensearch.model.RollbackOnDisable] =
      Optional.Absent,
    maintenanceSchedules: Optional[
      Iterable[zio.aws.opensearch.model.AutoTuneMaintenanceSchedule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AutoTuneOptions = {
    import AutoTuneOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptions
      .builder()
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .optionallyWith(rollbackOnDisable.map(value => value.unwrap))(
        _.rollbackOnDisable
      )
      .optionallyWith(
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.maintenanceSchedules)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AutoTuneOptions.ReadOnly =
    zio.aws.opensearch.model.AutoTuneOptions.wrap(buildAwsValue())
}
object AutoTuneOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AutoTuneOptions =
      zio.aws.opensearch.model.AutoTuneOptions(
        desiredState.map(value => value),
        rollbackOnDisable.map(value => value),
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def desiredState: Optional[zio.aws.opensearch.model.AutoTuneDesiredState]
    def rollbackOnDisable: Optional[zio.aws.opensearch.model.RollbackOnDisable]
    def maintenanceSchedules: Optional[
      List[zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.opensearch.model.AutoTuneDesiredState] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getRollbackOnDisable
        : ZIO[Any, AwsError, zio.aws.opensearch.model.RollbackOnDisable] =
      AwsError.unwrapOptionField("rollbackOnDisable", rollbackOnDisable)
    def getMaintenanceSchedules: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("maintenanceSchedules", maintenanceSchedules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptions
  ) extends zio.aws.opensearch.model.AutoTuneOptions.ReadOnly {
    override val desiredState
        : Optional[zio.aws.opensearch.model.AutoTuneDesiredState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredState())
        .map(value => zio.aws.opensearch.model.AutoTuneDesiredState.wrap(value))
    override val rollbackOnDisable
        : Optional[zio.aws.opensearch.model.RollbackOnDisable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rollbackOnDisable())
        .map(value => zio.aws.opensearch.model.RollbackOnDisable.wrap(value))
    override val maintenanceSchedules: Optional[
      List[zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceSchedules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptions
  ): zio.aws.opensearch.model.AutoTuneOptions.ReadOnly = new Wrapper(impl)
}
