package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AdvancedOptionsStatus(
    options: Map[String, String],
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AdvancedOptionsStatus = {
    import AdvancedOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AdvancedOptionsStatus
      .builder()
      .options(
        options
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AdvancedOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.AdvancedOptionsStatus.wrap(buildAwsValue())
}
object AdvancedOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AdvancedOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AdvancedOptionsStatus =
      zio.aws.opensearch.model.AdvancedOptionsStatus(options, status.asEditable)
    def options: Map[String, String]
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AdvancedOptionsStatus
  ) extends zio.aws.opensearch.model.AdvancedOptionsStatus.ReadOnly {
    override val options: Map[String, String] = impl
      .options()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AdvancedOptionsStatus
  ): zio.aws.opensearch.model.AdvancedOptionsStatus.ReadOnly = new Wrapper(impl)
}
