package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.VersionString
import scala.jdk.CollectionConverters._
final case class VersionStatus(
    options: VersionString,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.VersionStatus = {
    import VersionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.VersionStatus
      .builder()
      .options(VersionString.unwrap(options): java.lang.String)
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.VersionStatus.ReadOnly =
    zio.aws.opensearch.model.VersionStatus.wrap(buildAwsValue())
}
object VersionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.VersionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.VersionStatus =
      zio.aws.opensearch.model.VersionStatus(options, status.asEditable)
    def options: VersionString
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[Any, Nothing, VersionString] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.VersionStatus
  ) extends zio.aws.opensearch.model.VersionStatus.ReadOnly {
    override val options: VersionString =
      zio.aws.opensearch.model.primitives.VersionString(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.VersionStatus
  ): zio.aws.opensearch.model.VersionStatus.ReadOnly = new Wrapper(impl)
}
