package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait RollbackOnDisable {
  def unwrap: software.amazon.awssdk.services.opensearch.model.RollbackOnDisable
}
object RollbackOnDisable {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.RollbackOnDisable
  ): zio.aws.opensearch.model.RollbackOnDisable = value match {
    case software.amazon.awssdk.services.opensearch.model.RollbackOnDisable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.RollbackOnDisable.NO_ROLLBACK =>
      val r = NO_ROLLBACK
      r
    case software.amazon.awssdk.services.opensearch.model.RollbackOnDisable.DEFAULT_ROLLBACK =>
      val r = DEFAULT_ROLLBACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.RollbackOnDisable {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.RollbackOnDisable =
      software.amazon.awssdk.services.opensearch.model.RollbackOnDisable.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_ROLLBACK extends zio.aws.opensearch.model.RollbackOnDisable {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.RollbackOnDisable =
      software.amazon.awssdk.services.opensearch.model.RollbackOnDisable.NO_ROLLBACK
  }
  case object DEFAULT_ROLLBACK
      extends zio.aws.opensearch.model.RollbackOnDisable {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.RollbackOnDisable =
      software.amazon.awssdk.services.opensearch.model.RollbackOnDisable.DEFAULT_ROLLBACK
  }
}
