package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait OutboundConnectionStatusCode {
  def unwrap: software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode
}
object OutboundConnectionStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode
  ): zio.aws.opensearch.model.OutboundConnectionStatusCode = value match {
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.VALIDATING =>
      val r = VALIDATING
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.VALIDATION_FAILED =>
      val r = VALIDATION_FAILED
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.PENDING_ACCEPTANCE =>
      val r = PENDING_ACCEPTANCE
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.REJECTING =>
      val r = REJECTING
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATING
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.VALIDATING
  }
  case object VALIDATION_FAILED
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.VALIDATION_FAILED
  }
  case object PENDING_ACCEPTANCE
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.PENDING_ACCEPTANCE
  }
  case object APPROVED
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.APPROVED
  }
  case object PROVISIONING
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.PROVISIONING
  }
  case object ACTIVE
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.ACTIVE
  }
  case object REJECTING
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.REJECTING
  }
  case object REJECTED
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.REJECTED
  }
  case object DELETING
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.DELETING
  }
  case object DELETED
      extends zio.aws.opensearch.model.OutboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatusCode.DELETED
  }
}
