package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPackagesForDomainResponse(
    domainPackageDetailsList: Optional[
      Iterable[zio.aws.opensearch.model.DomainPackageDetails]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse = {
    import ListPackagesForDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse
      .builder()
      .optionallyWith(
        domainPackageDetailsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainPackageDetailsList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly =
    zio.aws.opensearch.model.ListPackagesForDomainResponse.wrap(buildAwsValue())
}
object ListPackagesForDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListPackagesForDomainResponse =
      zio.aws.opensearch.model.ListPackagesForDomainResponse(
        domainPackageDetailsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def domainPackageDetailsList
        : Optional[List[zio.aws.opensearch.model.DomainPackageDetails.ReadOnly]]
    def nextToken: Optional[String]
    def getDomainPackageDetailsList: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainPackageDetailsList",
      domainPackageDetailsList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse
  ) extends zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly {
    override val domainPackageDetailsList: Optional[
      List[zio.aws.opensearch.model.DomainPackageDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainPackageDetailsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.DomainPackageDetails.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse
  ): zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly =
    new Wrapper(impl)
}
