package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDomainNamesResponse(
    domainNames: Optional[Iterable[zio.aws.opensearch.model.DomainInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse = {
    import ListDomainNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse
      .builder()
      .optionallyWith(
        domainNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNames)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly =
    zio.aws.opensearch.model.ListDomainNamesResponse.wrap(buildAwsValue())
}
object ListDomainNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListDomainNamesResponse =
      zio.aws.opensearch.model.ListDomainNamesResponse(
        domainNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainNames
        : Optional[List[zio.aws.opensearch.model.DomainInfo.ReadOnly]]
    def getDomainNames: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.DomainInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("domainNames", domainNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse
  ) extends zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly {
    override val domainNames
        : Optional[List[zio.aws.opensearch.model.DomainInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.DomainInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse
  ): zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly = new Wrapper(
    impl
  )
}
