package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait InboundConnectionStatusCode {
  def unwrap: software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode
}
object InboundConnectionStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode
  ): zio.aws.opensearch.model.InboundConnectionStatusCode = value match {
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.PENDING_ACCEPTANCE =>
      val r = PENDING_ACCEPTANCE
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.REJECTING =>
      val r = REJECTING
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_ACCEPTANCE
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.PENDING_ACCEPTANCE
  }
  case object APPROVED
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.APPROVED
  }
  case object PROVISIONING
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.PROVISIONING
  }
  case object ACTIVE
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.ACTIVE
  }
  case object REJECTING
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.REJECTING
  }
  case object REJECTED
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.REJECTED
  }
  case object DELETING
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.DELETING
  }
  case object DELETED
      extends zio.aws.opensearch.model.InboundConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode =
      software.amazon.awssdk.services.opensearch.model.InboundConnectionStatusCode.DELETED
  }
}
