package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class DomainInfo(
    domainName: Optional[DomainName] = Optional.Absent,
    engineType: Optional[zio.aws.opensearch.model.EngineType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DomainInfo = {
    import DomainInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DomainInfo
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(engineType.map(value => value.unwrap))(_.engineType)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DomainInfo.ReadOnly =
    zio.aws.opensearch.model.DomainInfo.wrap(buildAwsValue())
}
object DomainInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DomainInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DomainInfo =
      zio.aws.opensearch.model.DomainInfo(
        domainName.map(value => value),
        engineType.map(value => value)
      )
    def domainName: Optional[DomainName]
    def engineType: Optional[zio.aws.opensearch.model.EngineType]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getEngineType: ZIO[Any, AwsError, zio.aws.opensearch.model.EngineType] =
      AwsError.unwrapOptionField("engineType", engineType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DomainInfo
  ) extends zio.aws.opensearch.model.DomainInfo.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.opensearch.model.primitives.DomainName(value))
    override val engineType: Optional[zio.aws.opensearch.model.EngineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineType())
        .map(value => zio.aws.opensearch.model.EngineType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DomainInfo
  ): zio.aws.opensearch.model.DomainInfo.ReadOnly = new Wrapper(impl)
}
