package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstanceOfferingsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    reservedInstanceOfferings: Optional[
      Iterable[zio.aws.opensearch.model.ReservedInstanceOffering]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse = {
    import DescribeReservedInstanceOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        reservedInstanceOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstanceOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedInstanceOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse =
      zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse(
        nextToken.map(value => value),
        reservedInstanceOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def reservedInstanceOfferings: Optional[
      List[zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedInstanceOfferings: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedInstanceOfferings",
      reservedInstanceOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse
  ) extends zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
    override val reservedInstanceOfferings: Optional[
      List[zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstanceOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.ReservedInstanceOffering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse
  ): zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
