package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePackageResponse(
    packageDetails: Optional[zio.aws.opensearch.model.PackageDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreatePackageResponse = {
    import CreatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreatePackageResponse
      .builder()
      .optionallyWith(packageDetails.map(value => value.buildAwsValue()))(
        _.packageDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.CreatePackageResponse.ReadOnly =
    zio.aws.opensearch.model.CreatePackageResponse.wrap(buildAwsValue())
}
object CreatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreatePackageResponse =
      zio.aws.opensearch.model
        .CreatePackageResponse(packageDetails.map(value => value.asEditable))
    def packageDetails
        : Optional[zio.aws.opensearch.model.PackageDetails.ReadOnly]
    def getPackageDetails
        : ZIO[Any, AwsError, zio.aws.opensearch.model.PackageDetails.ReadOnly] =
      AwsError.unwrapOptionField("packageDetails", packageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreatePackageResponse
  ) extends zio.aws.opensearch.model.CreatePackageResponse.ReadOnly {
    override val packageDetails
        : Optional[zio.aws.opensearch.model.PackageDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDetails())
        .map(value => zio.aws.opensearch.model.PackageDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreatePackageResponse
  ): zio.aws.opensearch.model.CreatePackageResponse.ReadOnly = new Wrapper(impl)
}
