package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{PackageDescription, PackageName}
import scala.jdk.CollectionConverters._
final case class CreatePackageRequest(
    packageName: PackageName,
    packageType: zio.aws.opensearch.model.PackageType,
    packageDescription: Optional[PackageDescription] = Optional.Absent,
    packageSource: zio.aws.opensearch.model.PackageSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreatePackageRequest = {
    import CreatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreatePackageRequest
      .builder()
      .packageName(PackageName.unwrap(packageName): java.lang.String)
      .packageType(packageType.unwrap)
      .optionallyWith(
        packageDescription.map(value =>
          PackageDescription.unwrap(value): java.lang.String
        )
      )(_.packageDescription)
      .packageSource(packageSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.CreatePackageRequest.ReadOnly =
    zio.aws.opensearch.model.CreatePackageRequest.wrap(buildAwsValue())
}
object CreatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreatePackageRequest =
      zio.aws.opensearch.model.CreatePackageRequest(
        packageName,
        packageType,
        packageDescription.map(value => value),
        packageSource.asEditable
      )
    def packageName: PackageName
    def packageType: zio.aws.opensearch.model.PackageType
    def packageDescription: Optional[PackageDescription]
    def packageSource: zio.aws.opensearch.model.PackageSource.ReadOnly
    def getPackageName: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageName)
    def getPackageType
        : ZIO[Any, Nothing, zio.aws.opensearch.model.PackageType] =
      ZIO.succeed(packageType)
    def getPackageDescription: ZIO[Any, AwsError, PackageDescription] =
      AwsError.unwrapOptionField("packageDescription", packageDescription)
    def getPackageSource
        : ZIO[Any, Nothing, zio.aws.opensearch.model.PackageSource.ReadOnly] =
      ZIO.succeed(packageSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreatePackageRequest
  ) extends zio.aws.opensearch.model.CreatePackageRequest.ReadOnly {
    override val packageName: PackageName =
      zio.aws.opensearch.model.primitives.PackageName(impl.packageName())
    override val packageType: zio.aws.opensearch.model.PackageType =
      zio.aws.opensearch.model.PackageType.wrap(impl.packageType())
    override val packageDescription: Optional[PackageDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDescription())
        .map(value =>
          zio.aws.opensearch.model.primitives.PackageDescription(value)
        )
    override val packageSource
        : zio.aws.opensearch.model.PackageSource.ReadOnly =
      zio.aws.opensearch.model.PackageSource.wrap(impl.packageSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreatePackageRequest
  ): zio.aws.opensearch.model.CreatePackageRequest.ReadOnly = new Wrapper(impl)
}
