package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.ConnectionAlias
import scala.jdk.CollectionConverters._
final case class CreateOutboundConnectionRequest(
    localDomainInfo: zio.aws.opensearch.model.DomainInformationContainer,
    remoteDomainInfo: zio.aws.opensearch.model.DomainInformationContainer,
    connectionAlias: ConnectionAlias
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest = {
    import CreateOutboundConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
      .builder()
      .localDomainInfo(localDomainInfo.buildAwsValue())
      .remoteDomainInfo(remoteDomainInfo.buildAwsValue())
      .connectionAlias(
        ConnectionAlias.unwrap(connectionAlias): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.CreateOutboundConnectionRequest.ReadOnly =
    zio.aws.opensearch.model.CreateOutboundConnectionRequest
      .wrap(buildAwsValue())
}
object CreateOutboundConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.CreateOutboundConnectionRequest =
      zio.aws.opensearch.model.CreateOutboundConnectionRequest(
        localDomainInfo.asEditable,
        remoteDomainInfo.asEditable,
        connectionAlias
      )
    def localDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    def remoteDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    def connectionAlias: ConnectionAlias
    def getLocalDomainInfo: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = ZIO.succeed(localDomainInfo)
    def getRemoteDomainInfo: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = ZIO.succeed(remoteDomainInfo)
    def getConnectionAlias: ZIO[Any, Nothing, ConnectionAlias] =
      ZIO.succeed(connectionAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
  ) extends zio.aws.opensearch.model.CreateOutboundConnectionRequest.ReadOnly {
    override val localDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly =
      zio.aws.opensearch.model.DomainInformationContainer
        .wrap(impl.localDomainInfo())
    override val remoteDomainInfo
        : zio.aws.opensearch.model.DomainInformationContainer.ReadOnly =
      zio.aws.opensearch.model.DomainInformationContainer
        .wrap(impl.remoteDomainInfo())
    override val connectionAlias: ConnectionAlias =
      zio.aws.opensearch.model.primitives
        .ConnectionAlias(impl.connectionAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest
  ): zio.aws.opensearch.model.CreateOutboundConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
