package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait ZoneStatus {
  def unwrap: software.amazon.awssdk.services.opensearch.model.ZoneStatus
}
object ZoneStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.ZoneStatus
  ): zio.aws.opensearch.model.ZoneStatus = value match {
    case software.amazon.awssdk.services.opensearch.model.ZoneStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.ZoneStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.opensearch.model.ZoneStatus.STAND_BY =>
      val r = StandBy
      r
    case software.amazon.awssdk.services.opensearch.model.ZoneStatus.NOT_AVAILABLE =>
      val r = NotAvailable
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.ZoneStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ZoneStatus =
      software.amazon.awssdk.services.opensearch.model.ZoneStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.opensearch.model.ZoneStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ZoneStatus =
      software.amazon.awssdk.services.opensearch.model.ZoneStatus.ACTIVE
  }
  case object StandBy extends zio.aws.opensearch.model.ZoneStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ZoneStatus =
      software.amazon.awssdk.services.opensearch.model.ZoneStatus.STAND_BY
  }
  case object NotAvailable extends zio.aws.opensearch.model.ZoneStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ZoneStatus =
      software.amazon.awssdk.services.opensearch.model.ZoneStatus.NOT_AVAILABLE
  }
}
