package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.{StartTimeMinutes, StartTimeHours}
import scala.jdk.CollectionConverters._
final case class WindowStartTime(
    hours: StartTimeHours,
    minutes: StartTimeMinutes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.WindowStartTime = {
    import WindowStartTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.WindowStartTime
      .builder()
      .hours(StartTimeHours.unwrap(hours): java.lang.Long)
      .minutes(StartTimeMinutes.unwrap(minutes): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.WindowStartTime.ReadOnly =
    zio.aws.opensearch.model.WindowStartTime.wrap(buildAwsValue())
}
object WindowStartTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.WindowStartTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.WindowStartTime =
      zio.aws.opensearch.model.WindowStartTime(hours, minutes)
    def hours: StartTimeHours
    def minutes: StartTimeMinutes
    def getHours: ZIO[Any, Nothing, StartTimeHours] = ZIO.succeed(hours)
    def getMinutes: ZIO[Any, Nothing, StartTimeMinutes] = ZIO.succeed(minutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.WindowStartTime
  ) extends zio.aws.opensearch.model.WindowStartTime.ReadOnly {
    override val hours: StartTimeHours =
      zio.aws.opensearch.model.primitives.StartTimeHours(impl.hours())
    override val minutes: StartTimeMinutes =
      zio.aws.opensearch.model.primitives.StartTimeMinutes(impl.minutes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.WindowStartTime
  ): zio.aws.opensearch.model.WindowStartTime.ReadOnly = new Wrapper(impl)
}
