package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{DomainArn, VpcEndpointId}
import scala.jdk.CollectionConverters._
final case class VpcEndpointSummary(
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    vpcEndpointOwner: Optional[String] = Optional.Absent,
    domainArn: Optional[DomainArn] = Optional.Absent,
    status: Optional[zio.aws.opensearch.model.VpcEndpointStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.VpcEndpointSummary = {
    import VpcEndpointSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.VpcEndpointSummary
      .builder()
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(vpcEndpointOwner.map(value => value: java.lang.String))(
        _.vpcEndpointOwner
      )
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly =
    zio.aws.opensearch.model.VpcEndpointSummary.wrap(buildAwsValue())
}
object VpcEndpointSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.VpcEndpointSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.VpcEndpointSummary =
      zio.aws.opensearch.model.VpcEndpointSummary(
        vpcEndpointId.map(value => value),
        vpcEndpointOwner.map(value => value),
        domainArn.map(value => value),
        status.map(value => value)
      )
    def vpcEndpointId: Optional[VpcEndpointId]
    def vpcEndpointOwner: Optional[String]
    def domainArn: Optional[DomainArn]
    def status: Optional[zio.aws.opensearch.model.VpcEndpointStatus]
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcEndpointOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointOwner", vpcEndpointOwner)
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VpcEndpointStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.VpcEndpointSummary
  ) extends zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly {
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.opensearch.model.primitives.VpcEndpointId(value))
    override val vpcEndpointOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointOwner())
      .map(value => value: String)
    override val domainArn: Optional[DomainArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainArn())
      .map(value => zio.aws.opensearch.model.primitives.DomainArn(value))
    override val status: Optional[zio.aws.opensearch.model.VpcEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opensearch.model.VpcEndpointStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.VpcEndpointSummary
  ): zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly = new Wrapper(impl)
}
