package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.VpcEndpointId
import scala.jdk.CollectionConverters._
final case class VpcEndpointError(
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    errorCode: Optional[zio.aws.opensearch.model.VpcEndpointErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.VpcEndpointError = {
    import VpcEndpointError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.VpcEndpointError
      .builder()
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.VpcEndpointError.ReadOnly =
    zio.aws.opensearch.model.VpcEndpointError.wrap(buildAwsValue())
}
object VpcEndpointError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.VpcEndpointError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.VpcEndpointError =
      zio.aws.opensearch.model.VpcEndpointError(
        vpcEndpointId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def vpcEndpointId: Optional[VpcEndpointId]
    def errorCode: Optional[zio.aws.opensearch.model.VpcEndpointErrorCode]
    def errorMessage: Optional[String]
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VpcEndpointErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.VpcEndpointError
  ) extends zio.aws.opensearch.model.VpcEndpointError.ReadOnly {
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.opensearch.model.primitives.VpcEndpointId(value))
    override val errorCode
        : Optional[zio.aws.opensearch.model.VpcEndpointErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.opensearch.model.VpcEndpointErrorCode.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.VpcEndpointError
  ): zio.aws.opensearch.model.VpcEndpointError.ReadOnly = new Wrapper(impl)
}
