package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{
  Endpoint,
  DomainArn,
  AWSAccount,
  VpcEndpointId
}
import scala.jdk.CollectionConverters._
final case class VpcEndpoint(
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    vpcEndpointOwner: Optional[AWSAccount] = Optional.Absent,
    domainArn: Optional[DomainArn] = Optional.Absent,
    vpcOptions: Optional[zio.aws.opensearch.model.VPCDerivedInfo] =
      Optional.Absent,
    status: Optional[zio.aws.opensearch.model.VpcEndpointStatus] =
      Optional.Absent,
    endpoint: Optional[Endpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.VpcEndpoint = {
    import VpcEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.VpcEndpoint
      .builder()
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(
        vpcEndpointOwner.map(value =>
          AWSAccount.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointOwner)
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        endpoint.map(value => Endpoint.unwrap(value): java.lang.String)
      )(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.VpcEndpoint.ReadOnly =
    zio.aws.opensearch.model.VpcEndpoint.wrap(buildAwsValue())
}
object VpcEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.VpcEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.VpcEndpoint =
      zio.aws.opensearch.model.VpcEndpoint(
        vpcEndpointId.map(value => value),
        vpcEndpointOwner.map(value => value),
        domainArn.map(value => value),
        vpcOptions.map(value => value.asEditable),
        status.map(value => value),
        endpoint.map(value => value)
      )
    def vpcEndpointId: Optional[VpcEndpointId]
    def vpcEndpointOwner: Optional[AWSAccount]
    def domainArn: Optional[DomainArn]
    def vpcOptions: Optional[zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly]
    def status: Optional[zio.aws.opensearch.model.VpcEndpointStatus]
    def endpoint: Optional[Endpoint]
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcEndpointOwner: ZIO[Any, AwsError, AWSAccount] =
      AwsError.unwrapOptionField("vpcEndpointOwner", vpcEndpointOwner)
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VpcEndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEndpoint: ZIO[Any, AwsError, Endpoint] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.VpcEndpoint
  ) extends zio.aws.opensearch.model.VpcEndpoint.ReadOnly {
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.opensearch.model.primitives.VpcEndpointId(value))
    override val vpcEndpointOwner: Optional[AWSAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointOwner())
      .map(value => zio.aws.opensearch.model.primitives.AWSAccount(value))
    override val domainArn: Optional[DomainArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainArn())
      .map(value => zio.aws.opensearch.model.primitives.DomainArn(value))
    override val vpcOptions
        : Optional[zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value => zio.aws.opensearch.model.VPCDerivedInfo.wrap(value))
    override val status: Optional[zio.aws.opensearch.model.VpcEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opensearch.model.VpcEndpointStatus.wrap(value))
    override val endpoint: Optional[Endpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.opensearch.model.primitives.Endpoint(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.VpcEndpoint
  ): zio.aws.opensearch.model.VpcEndpoint.ReadOnly = new Wrapper(impl)
}
