package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVpcEndpointResponse(
    vpcEndpoint: zio.aws.opensearch.model.VpcEndpoint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse = {
    import UpdateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse
      .builder()
      .vpcEndpoint(vpcEndpoint.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpdateVpcEndpointResponse.ReadOnly =
    zio.aws.opensearch.model.UpdateVpcEndpointResponse.wrap(buildAwsValue())
}
object UpdateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdateVpcEndpointResponse =
      zio.aws.opensearch.model.UpdateVpcEndpointResponse(vpcEndpoint.asEditable)
    def vpcEndpoint: zio.aws.opensearch.model.VpcEndpoint.ReadOnly
    def getVpcEndpoint
        : ZIO[Any, Nothing, zio.aws.opensearch.model.VpcEndpoint.ReadOnly] =
      ZIO.succeed(vpcEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse
  ) extends zio.aws.opensearch.model.UpdateVpcEndpointResponse.ReadOnly {
    override val vpcEndpoint: zio.aws.opensearch.model.VpcEndpoint.ReadOnly =
      zio.aws.opensearch.model.VpcEndpoint.wrap(impl.vpcEndpoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse
  ): zio.aws.opensearch.model.UpdateVpcEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
