package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.VpcEndpointId
import scala.jdk.CollectionConverters._
final case class UpdateVpcEndpointRequest(
    vpcEndpointId: VpcEndpointId,
    vpcOptions: zio.aws.opensearch.model.VPCOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest = {
    import UpdateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest
      .builder()
      .vpcEndpointId(VpcEndpointId.unwrap(vpcEndpointId): java.lang.String)
      .vpcOptions(vpcOptions.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpdateVpcEndpointRequest.ReadOnly =
    zio.aws.opensearch.model.UpdateVpcEndpointRequest.wrap(buildAwsValue())
}
object UpdateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdateVpcEndpointRequest =
      zio.aws.opensearch.model
        .UpdateVpcEndpointRequest(vpcEndpointId, vpcOptions.asEditable)
    def vpcEndpointId: VpcEndpointId
    def vpcOptions: zio.aws.opensearch.model.VPCOptions.ReadOnly
    def getVpcEndpointId: ZIO[Any, Nothing, VpcEndpointId] =
      ZIO.succeed(vpcEndpointId)
    def getVpcOptions
        : ZIO[Any, Nothing, zio.aws.opensearch.model.VPCOptions.ReadOnly] =
      ZIO.succeed(vpcOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest
  ) extends zio.aws.opensearch.model.UpdateVpcEndpointRequest.ReadOnly {
    override val vpcEndpointId: VpcEndpointId =
      zio.aws.opensearch.model.primitives.VpcEndpointId(impl.vpcEndpointId())
    override val vpcOptions: zio.aws.opensearch.model.VPCOptions.ReadOnly =
      zio.aws.opensearch.model.VPCOptions.wrap(impl.vpcOptions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest
  ): zio.aws.opensearch.model.UpdateVpcEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
