package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateScheduledActionResponse(
    scheduledAction: Optional[zio.aws.opensearch.model.ScheduledAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse = {
    import UpdateScheduledActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse
      .builder()
      .optionallyWith(scheduledAction.map(value => value.buildAwsValue()))(
        _.scheduledAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.UpdateScheduledActionResponse.ReadOnly =
    zio.aws.opensearch.model.UpdateScheduledActionResponse.wrap(buildAwsValue())
}
object UpdateScheduledActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdateScheduledActionResponse =
      zio.aws.opensearch.model.UpdateScheduledActionResponse(
        scheduledAction.map(value => value.asEditable)
      )
    def scheduledAction
        : Optional[zio.aws.opensearch.model.ScheduledAction.ReadOnly]
    def getScheduledAction: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ScheduledAction.ReadOnly
    ] = AwsError.unwrapOptionField("scheduledAction", scheduledAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse
  ) extends zio.aws.opensearch.model.UpdateScheduledActionResponse.ReadOnly {
    override val scheduledAction
        : Optional[zio.aws.opensearch.model.ScheduledAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAction())
        .map(value => zio.aws.opensearch.model.ScheduledAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse
  ): zio.aws.opensearch.model.UpdateScheduledActionResponse.ReadOnly =
    new Wrapper(impl)
}
