package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class UpdateScheduledActionRequest(
    domainName: DomainName,
    actionID: String,
    actionType: zio.aws.opensearch.model.ActionType,
    scheduleAt: zio.aws.opensearch.model.ScheduleAt,
    desiredStartTime: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest = {
    import UpdateScheduledActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .actionID(actionID: java.lang.String)
      .actionType(actionType.unwrap)
      .scheduleAt(scheduleAt.unwrap)
      .optionallyWith(desiredStartTime.map(value => value: java.lang.Long))(
        _.desiredStartTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.UpdateScheduledActionRequest.ReadOnly =
    zio.aws.opensearch.model.UpdateScheduledActionRequest.wrap(buildAwsValue())
}
object UpdateScheduledActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdateScheduledActionRequest =
      zio.aws.opensearch.model.UpdateScheduledActionRequest(
        domainName,
        actionID,
        actionType,
        scheduleAt,
        desiredStartTime.map(value => value)
      )
    def domainName: DomainName
    def actionID: String
    def actionType: zio.aws.opensearch.model.ActionType
    def scheduleAt: zio.aws.opensearch.model.ScheduleAt
    def desiredStartTime: Optional[Long]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getActionID: ZIO[Any, Nothing, String] = ZIO.succeed(actionID)
    def getActionType: ZIO[Any, Nothing, zio.aws.opensearch.model.ActionType] =
      ZIO.succeed(actionType)
    def getScheduleAt: ZIO[Any, Nothing, zio.aws.opensearch.model.ScheduleAt] =
      ZIO.succeed(scheduleAt)
    def getDesiredStartTime: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("desiredStartTime", desiredStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest
  ) extends zio.aws.opensearch.model.UpdateScheduledActionRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val actionID: String = impl.actionID(): String
    override val actionType: zio.aws.opensearch.model.ActionType =
      zio.aws.opensearch.model.ActionType.wrap(impl.actionType())
    override val scheduleAt: zio.aws.opensearch.model.ScheduleAt =
      zio.aws.opensearch.model.ScheduleAt.wrap(impl.scheduleAt())
    override val desiredStartTime: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredStartTime())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest
  ): zio.aws.opensearch.model.UpdateScheduledActionRequest.ReadOnly =
    new Wrapper(impl)
}
