package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{DryRun, PolicyDocument, DomainName}
import scala.jdk.CollectionConverters._
final case class UpdateDomainConfigRequest(
    domainName: DomainName,
    clusterConfig: Optional[zio.aws.opensearch.model.ClusterConfig] =
      Optional.Absent,
    ebsOptions: Optional[zio.aws.opensearch.model.EBSOptions] = Optional.Absent,
    snapshotOptions: Optional[zio.aws.opensearch.model.SnapshotOptions] =
      Optional.Absent,
    vpcOptions: Optional[zio.aws.opensearch.model.VPCOptions] = Optional.Absent,
    cognitoOptions: Optional[zio.aws.opensearch.model.CognitoOptions] =
      Optional.Absent,
    advancedOptions: Optional[Map[String, String]] = Optional.Absent,
    accessPolicies: Optional[PolicyDocument] = Optional.Absent,
    logPublishingOptions: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption
    ]] = Optional.Absent,
    encryptionAtRestOptions: Optional[
      zio.aws.opensearch.model.EncryptionAtRestOptions
    ] = Optional.Absent,
    domainEndpointOptions: Optional[
      zio.aws.opensearch.model.DomainEndpointOptions
    ] = Optional.Absent,
    nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions
    ] = Optional.Absent,
    advancedSecurityOptions: Optional[
      zio.aws.opensearch.model.AdvancedSecurityOptionsInput
    ] = Optional.Absent,
    autoTuneOptions: Optional[zio.aws.opensearch.model.AutoTuneOptions] =
      Optional.Absent,
    dryRun: Optional[DryRun] = Optional.Absent,
    dryRunMode: Optional[zio.aws.opensearch.model.DryRunMode] = Optional.Absent,
    offPeakWindowOptions: Optional[
      zio.aws.opensearch.model.OffPeakWindowOptions
    ] = Optional.Absent,
    softwareUpdateOptions: Optional[
      zio.aws.opensearch.model.SoftwareUpdateOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest = {
    import UpdateDomainConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(clusterConfig.map(value => value.buildAwsValue()))(
        _.clusterConfig
      )
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .optionallyWith(
        accessPolicies.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(
        logPublishingOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.logPublishingOptionsWithStrings)
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .optionallyWith(dryRunMode.map(value => value.unwrap))(_.dryRunMode)
      .optionallyWith(offPeakWindowOptions.map(value => value.buildAwsValue()))(
        _.offPeakWindowOptions
      )
      .optionallyWith(
        softwareUpdateOptions.map(value => value.buildAwsValue())
      )(_.softwareUpdateOptions)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpdateDomainConfigRequest.ReadOnly =
    zio.aws.opensearch.model.UpdateDomainConfigRequest.wrap(buildAwsValue())
}
object UpdateDomainConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdateDomainConfigRequest =
      zio.aws.opensearch.model.UpdateDomainConfigRequest(
        domainName,
        clusterConfig.map(value => value.asEditable),
        ebsOptions.map(value => value.asEditable),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        advancedOptions.map(value => value),
        accessPolicies.map(value => value),
        logPublishingOptions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        encryptionAtRestOptions.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable),
        dryRun.map(value => value),
        dryRunMode.map(value => value),
        offPeakWindowOptions.map(value => value.asEditable),
        softwareUpdateOptions.map(value => value.asEditable)
      )
    def domainName: DomainName
    def clusterConfig: Optional[zio.aws.opensearch.model.ClusterConfig.ReadOnly]
    def ebsOptions: Optional[zio.aws.opensearch.model.EBSOptions.ReadOnly]
    def snapshotOptions
        : Optional[zio.aws.opensearch.model.SnapshotOptions.ReadOnly]
    def vpcOptions: Optional[zio.aws.opensearch.model.VPCOptions.ReadOnly]
    def cognitoOptions
        : Optional[zio.aws.opensearch.model.CognitoOptions.ReadOnly]
    def advancedOptions: Optional[Map[String, String]]
    def accessPolicies: Optional[PolicyDocument]
    def logPublishingOptions: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]]
    def encryptionAtRestOptions
        : Optional[zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly]
    def domainEndpointOptions
        : Optional[zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly]
    def nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ]
    def advancedSecurityOptions: Optional[
      zio.aws.opensearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ]
    def autoTuneOptions
        : Optional[zio.aws.opensearch.model.AutoTuneOptions.ReadOnly]
    def dryRun: Optional[DryRun]
    def dryRunMode: Optional[zio.aws.opensearch.model.DryRunMode]
    def offPeakWindowOptions
        : Optional[zio.aws.opensearch.model.OffPeakWindowOptions.ReadOnly]
    def softwareUpdateOptions
        : Optional[zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getClusterConfig
        : ZIO[Any, AwsError, zio.aws.opensearch.model.ClusterConfig.ReadOnly] =
      AwsError.unwrapOptionField("clusterConfig", clusterConfig)
    def getEbsOptions
        : ZIO[Any, AwsError, zio.aws.opensearch.model.EBSOptions.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.SnapshotOptions.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VPCOptions.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions
        : ZIO[Any, AwsError, zio.aws.opensearch.model.CognitoOptions.ReadOnly] =
      AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getAccessPolicies: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getLogPublishingOptions: ZIO[Any, AwsError, Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AutoTuneOptions.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getDryRunMode: ZIO[Any, AwsError, zio.aws.opensearch.model.DryRunMode] =
      AwsError.unwrapOptionField("dryRunMode", dryRunMode)
    def getOffPeakWindowOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OffPeakWindowOptions.ReadOnly
    ] = AwsError.unwrapOptionField("offPeakWindowOptions", offPeakWindowOptions)
    def getSoftwareUpdateOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("softwareUpdateOptions", softwareUpdateOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest
  ) extends zio.aws.opensearch.model.UpdateDomainConfigRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val clusterConfig
        : Optional[zio.aws.opensearch.model.ClusterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterConfig())
        .map(value => zio.aws.opensearch.model.ClusterConfig.wrap(value))
    override val ebsOptions
        : Optional[zio.aws.opensearch.model.EBSOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptions())
        .map(value => zio.aws.opensearch.model.EBSOptions.wrap(value))
    override val snapshotOptions
        : Optional[zio.aws.opensearch.model.SnapshotOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotOptions())
        .map(value => zio.aws.opensearch.model.SnapshotOptions.wrap(value))
    override val vpcOptions
        : Optional[zio.aws.opensearch.model.VPCOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value => zio.aws.opensearch.model.VPCOptions.wrap(value))
    override val cognitoOptions
        : Optional[zio.aws.opensearch.model.CognitoOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoOptions())
        .map(value => zio.aws.opensearch.model.CognitoOptions.wrap(value))
    override val advancedOptions: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val accessPolicies: Optional[PolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPolicies())
        .map(value => zio.aws.opensearch.model.primitives.PolicyDocument(value))
    override val logPublishingOptions: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.opensearch.model.LogType.wrap(
              key
            ) -> zio.aws.opensearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val encryptionAtRestOptions
        : Optional[zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAtRestOptions())
        .map(value =>
          zio.aws.opensearch.model.EncryptionAtRestOptions.wrap(value)
        )
    override val domainEndpointOptions
        : Optional[zio.aws.opensearch.model.DomainEndpointOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainEndpointOptions())
        .map(value =>
          zio.aws.opensearch.model.DomainEndpointOptions.wrap(value)
        )
    override val nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.opensearch.model.NodeToNodeEncryptionOptions.wrap(value)
      )
    override val advancedSecurityOptions: Optional[
      zio.aws.opensearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.opensearch.model.AdvancedSecurityOptionsInput.wrap(value)
      )
    override val autoTuneOptions
        : Optional[zio.aws.opensearch.model.AutoTuneOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneOptions())
        .map(value => zio.aws.opensearch.model.AutoTuneOptions.wrap(value))
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.opensearch.model.primitives.DryRun(value))
    override val dryRunMode: Optional[zio.aws.opensearch.model.DryRunMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dryRunMode())
        .map(value => zio.aws.opensearch.model.DryRunMode.wrap(value))
    override val offPeakWindowOptions
        : Optional[zio.aws.opensearch.model.OffPeakWindowOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offPeakWindowOptions())
        .map(value => zio.aws.opensearch.model.OffPeakWindowOptions.wrap(value))
    override val softwareUpdateOptions
        : Optional[zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.softwareUpdateOptions())
        .map(value =>
          zio.aws.opensearch.model.SoftwareUpdateOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest
  ): zio.aws.opensearch.model.UpdateDomainConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
