package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters._
final case class StartServiceSoftwareUpdateRequest(
    domainName: DomainName,
    scheduleAt: Optional[zio.aws.opensearch.model.ScheduleAt] = Optional.Absent,
    desiredStartTime: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest = {
    import StartServiceSoftwareUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(scheduleAt.map(value => value.unwrap))(_.scheduleAt)
      .optionallyWith(desiredStartTime.map(value => value: java.lang.Long))(
        _.desiredStartTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest.ReadOnly =
    zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest
      .wrap(buildAwsValue())
}
object StartServiceSoftwareUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest =
      zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest(
        domainName,
        scheduleAt.map(value => value),
        desiredStartTime.map(value => value)
      )
    def domainName: DomainName
    def scheduleAt: Optional[zio.aws.opensearch.model.ScheduleAt]
    def desiredStartTime: Optional[Long]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getScheduleAt: ZIO[Any, AwsError, zio.aws.opensearch.model.ScheduleAt] =
      AwsError.unwrapOptionField("scheduleAt", scheduleAt)
    def getDesiredStartTime: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("desiredStartTime", desiredStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
  ) extends zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val scheduleAt: Optional[zio.aws.opensearch.model.ScheduleAt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleAt())
        .map(value => zio.aws.opensearch.model.ScheduleAt.wrap(value))
    override val desiredStartTime: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredStartTime())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
  ): zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
