package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SoftwareUpdateOptionsStatus(
    options: Optional[zio.aws.opensearch.model.SoftwareUpdateOptions] =
      Optional.Absent,
    status: Optional[zio.aws.opensearch.model.OptionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptionsStatus = {
    import SoftwareUpdateOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptionsStatus
      .builder()
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.SoftwareUpdateOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.SoftwareUpdateOptionsStatus.wrap(buildAwsValue())
}
object SoftwareUpdateOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.SoftwareUpdateOptionsStatus =
      zio.aws.opensearch.model.SoftwareUpdateOptionsStatus(
        options.map(value => value.asEditable),
        status.map(value => value.asEditable)
      )
    def options
        : Optional[zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly]
    def status: Optional[zio.aws.opensearch.model.OptionStatus.ReadOnly]
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptionsStatus
  ) extends zio.aws.opensearch.model.SoftwareUpdateOptionsStatus.ReadOnly {
    override val options
        : Optional[zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          zio.aws.opensearch.model.SoftwareUpdateOptions.wrap(value)
        )
    override val status
        : Optional[zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opensearch.model.OptionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptionsStatus
  ): zio.aws.opensearch.model.SoftwareUpdateOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
