package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SoftwareUpdateOptions(
    autoSoftwareUpdateEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptions = {
    import SoftwareUpdateOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptions
      .builder()
      .optionallyWith(
        autoSoftwareUpdateEnabled.map(value => value: java.lang.Boolean)
      )(_.autoSoftwareUpdateEnabled)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly =
    zio.aws.opensearch.model.SoftwareUpdateOptions.wrap(buildAwsValue())
}
object SoftwareUpdateOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.SoftwareUpdateOptions =
      zio.aws.opensearch.model
        .SoftwareUpdateOptions(autoSoftwareUpdateEnabled.map(value => value))
    def autoSoftwareUpdateEnabled: Optional[Boolean]
    def getAutoSoftwareUpdateEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoSoftwareUpdateEnabled", autoSoftwareUpdateEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptions
  ) extends zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly {
    override val autoSoftwareUpdateEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoSoftwareUpdateEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptions
  ): zio.aws.opensearch.model.SoftwareUpdateOptions.ReadOnly = new Wrapper(impl)
}
