package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduledAction(
    id: String,
    `type`: zio.aws.opensearch.model.ActionType,
    severity: zio.aws.opensearch.model.ActionSeverity,
    scheduledTime: Long,
    description: Optional[String] = Optional.Absent,
    scheduledBy: Optional[zio.aws.opensearch.model.ScheduledBy] =
      Optional.Absent,
    status: Optional[zio.aws.opensearch.model.ActionStatus] = Optional.Absent,
    mandatory: Optional[Boolean] = Optional.Absent,
    cancellable: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ScheduledAction = {
    import ScheduledAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ScheduledAction
      .builder()
      .id(id: java.lang.String)
      .`type`(`type`.unwrap)
      .severity(severity.unwrap)
      .scheduledTime(scheduledTime: java.lang.Long)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(scheduledBy.map(value => value.unwrap))(_.scheduledBy)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(mandatory.map(value => value: java.lang.Boolean))(
        _.mandatory
      )
      .optionallyWith(cancellable.map(value => value: java.lang.Boolean))(
        _.cancellable
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ScheduledAction.ReadOnly =
    zio.aws.opensearch.model.ScheduledAction.wrap(buildAwsValue())
}
object ScheduledAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ScheduledAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ScheduledAction =
      zio.aws.opensearch.model.ScheduledAction(
        id,
        `type`,
        severity,
        scheduledTime,
        description.map(value => value),
        scheduledBy.map(value => value),
        status.map(value => value),
        mandatory.map(value => value),
        cancellable.map(value => value)
      )
    def id: String
    def `type`: zio.aws.opensearch.model.ActionType
    def severity: zio.aws.opensearch.model.ActionSeverity
    def scheduledTime: Long
    def description: Optional[String]
    def scheduledBy: Optional[zio.aws.opensearch.model.ScheduledBy]
    def status: Optional[zio.aws.opensearch.model.ActionStatus]
    def mandatory: Optional[Boolean]
    def cancellable: Optional[Boolean]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getType: ZIO[Any, Nothing, zio.aws.opensearch.model.ActionType] =
      ZIO.succeed(`type`)
    def getSeverity
        : ZIO[Any, Nothing, zio.aws.opensearch.model.ActionSeverity] =
      ZIO.succeed(severity)
    def getScheduledTime: ZIO[Any, Nothing, Long] = ZIO.succeed(scheduledTime)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getScheduledBy
        : ZIO[Any, AwsError, zio.aws.opensearch.model.ScheduledBy] =
      AwsError.unwrapOptionField("scheduledBy", scheduledBy)
    def getStatus: ZIO[Any, AwsError, zio.aws.opensearch.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMandatory: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mandatory", mandatory)
    def getCancellable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cancellable", cancellable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ScheduledAction
  ) extends zio.aws.opensearch.model.ScheduledAction.ReadOnly {
    override val id: String = impl.id(): String
    override val `type`: zio.aws.opensearch.model.ActionType =
      zio.aws.opensearch.model.ActionType.wrap(impl.`type`())
    override val severity: zio.aws.opensearch.model.ActionSeverity =
      zio.aws.opensearch.model.ActionSeverity.wrap(impl.severity())
    override val scheduledTime: Long = impl.scheduledTime(): Long
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val scheduledBy: Optional[zio.aws.opensearch.model.ScheduledBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledBy())
        .map(value => zio.aws.opensearch.model.ScheduledBy.wrap(value))
    override val status: Optional[zio.aws.opensearch.model.ActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opensearch.model.ActionStatus.wrap(value))
    override val mandatory: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.mandatory())
      .map(value => value: Boolean)
    override val cancellable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cancellable())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ScheduledAction
  ): zio.aws.opensearch.model.ScheduledAction.ReadOnly = new Wrapper(impl)
}
