package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait ScheduleAt {
  def unwrap: software.amazon.awssdk.services.opensearch.model.ScheduleAt
}
object ScheduleAt {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.ScheduleAt
  ): zio.aws.opensearch.model.ScheduleAt = value match {
    case software.amazon.awssdk.services.opensearch.model.ScheduleAt.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.ScheduleAt.NOW =>
      val r = NOW
      r
    case software.amazon.awssdk.services.opensearch.model.ScheduleAt.TIMESTAMP =>
      val r = TIMESTAMP
      r
    case software.amazon.awssdk.services.opensearch.model.ScheduleAt.OFF_PEAK_WINDOW =>
      val r = OFF_PEAK_WINDOW
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.ScheduleAt {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ScheduleAt =
      software.amazon.awssdk.services.opensearch.model.ScheduleAt.UNKNOWN_TO_SDK_VERSION
  }
  case object NOW extends zio.aws.opensearch.model.ScheduleAt {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ScheduleAt =
      software.amazon.awssdk.services.opensearch.model.ScheduleAt.NOW
  }
  case object TIMESTAMP extends zio.aws.opensearch.model.ScheduleAt {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ScheduleAt =
      software.amazon.awssdk.services.opensearch.model.ScheduleAt.TIMESTAMP
  }
  case object OFF_PEAK_WINDOW extends zio.aws.opensearch.model.ScheduleAt {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ScheduleAt =
      software.amazon.awssdk.services.opensearch.model.ScheduleAt.OFF_PEAK_WINDOW
  }
}
