package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.{AWSAccount, DomainName}
import scala.jdk.CollectionConverters._
final case class RevokeVpcEndpointAccessRequest(
    domainName: DomainName,
    account: AWSAccount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest = {
    import RevokeVpcEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .account(AWSAccount.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest.ReadOnly =
    zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest
      .wrap(buildAwsValue())
}
object RevokeVpcEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest =
      zio.aws.opensearch.model
        .RevokeVpcEndpointAccessRequest(domainName, account)
    def domainName: DomainName
    def account: AWSAccount
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getAccount: ZIO[Any, Nothing, AWSAccount] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest
  ) extends zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val account: AWSAccount =
      zio.aws.opensearch.model.primitives.AWSAccount(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest
  ): zio.aws.opensearch.model.RevokeVpcEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
