package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait ReservedInstancePaymentOption {
  def unwrap: software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption
}
object ReservedInstancePaymentOption {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption
  ): zio.aws.opensearch.model.ReservedInstancePaymentOption = value match {
    case software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.ALL_UPFRONT =>
      val r = ALL_UPFRONT
      r
    case software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.PARTIAL_UPFRONT =>
      val r = PARTIAL_UPFRONT
      r
    case software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.NO_UPFRONT =>
      val r = NO_UPFRONT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.ReservedInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption =
      software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL_UPFRONT
      extends zio.aws.opensearch.model.ReservedInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption =
      software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.ALL_UPFRONT
  }
  case object PARTIAL_UPFRONT
      extends zio.aws.opensearch.model.ReservedInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption =
      software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.PARTIAL_UPFRONT
  }
  case object NO_UPFRONT
      extends zio.aws.opensearch.model.ReservedInstancePaymentOption {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption =
      software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption.NO_UPFRONT
  }
}
