package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{Integer, GUID}
import scala.jdk.CollectionConverters._
final case class ReservedInstanceOffering(
    reservedInstanceOfferingId: Optional[GUID] = Optional.Absent,
    instanceType: Optional[
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    paymentOption: Optional[
      zio.aws.opensearch.model.ReservedInstancePaymentOption
    ] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.opensearch.model.RecurringCharge]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering = {
    import ReservedInstanceOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering
      .builder()
      .optionallyWith(
        reservedInstanceOfferingId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedInstanceOfferingId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly =
    zio.aws.opensearch.model.ReservedInstanceOffering.wrap(buildAwsValue())
}
object ReservedInstanceOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ReservedInstanceOffering =
      zio.aws.opensearch.model.ReservedInstanceOffering(
        reservedInstanceOfferingId.map(value => value),
        instanceType.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        paymentOption.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedInstanceOfferingId: Optional[GUID]
    def instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def currencyCode: Optional[String]
    def paymentOption
        : Optional[zio.aws.opensearch.model.ReservedInstancePaymentOption]
    def recurringCharges
        : Optional[List[zio.aws.opensearch.model.RecurringCharge.ReadOnly]]
    def getReservedInstanceOfferingId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedInstanceOfferingId",
        reservedInstanceOfferingId
      )
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ReservedInstancePaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering
  ) extends zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly {
    override val reservedInstanceOfferingId: Optional[GUID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstanceOfferingId())
        .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.opensearch.model.OpenSearchPartitionInstanceType.wrap(value)
        )
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val paymentOption
        : Optional[zio.aws.opensearch.model.ReservedInstancePaymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOption())
        .map(value =>
          zio.aws.opensearch.model.ReservedInstancePaymentOption.wrap(value)
        )
    override val recurringCharges
        : Optional[List[zio.aws.opensearch.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering
  ): zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly = new Wrapper(
    impl
  )
}
