package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{
  InstanceCount,
  ReservationToken,
  GUID
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PurchaseReservedInstanceOfferingRequest(
    reservedInstanceOfferingId: GUID,
    reservationName: ReservationToken,
    instanceCount: Optional[InstanceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest = {
    import PurchaseReservedInstanceOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest
      .builder()
      .reservedInstanceOfferingId(
        GUID.unwrap(reservedInstanceOfferingId): java.lang.String
      )
      .reservationName(
        ReservationToken.unwrap(reservationName): java.lang.String
      )
      .optionallyWith(
        instanceCount.map(value => InstanceCount.unwrap(value): Integer)
      )(_.instanceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest.ReadOnly =
    zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedInstanceOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest =
      zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest(
        reservedInstanceOfferingId,
        reservationName,
        instanceCount.map(value => value)
      )
    def reservedInstanceOfferingId: GUID
    def reservationName: ReservationToken
    def instanceCount: Optional[InstanceCount]
    def getReservedInstanceOfferingId: ZIO[Any, Nothing, GUID] =
      ZIO.succeed(reservedInstanceOfferingId)
    def getReservationName: ZIO[Any, Nothing, ReservationToken] =
      ZIO.succeed(reservationName)
    def getInstanceCount: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest
  ) extends zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest.ReadOnly {
    override val reservedInstanceOfferingId: GUID =
      zio.aws.opensearch.model.primitives
        .GUID(impl.reservedInstanceOfferingId())
    override val reservationName: ReservationToken =
      zio.aws.opensearch.model.primitives
        .ReservationToken(impl.reservationName())
    override val instanceCount: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => zio.aws.opensearch.model.primitives.InstanceCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest
  ): zio.aws.opensearch.model.PurchaseReservedInstanceOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
