package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OffPeakWindowOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    offPeakWindow: Optional[zio.aws.opensearch.model.OffPeakWindow] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptions = {
    import OffPeakWindowOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(offPeakWindow.map(value => value.buildAwsValue()))(
        _.offPeakWindow
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.OffPeakWindowOptions.ReadOnly =
    zio.aws.opensearch.model.OffPeakWindowOptions.wrap(buildAwsValue())
}
object OffPeakWindowOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.OffPeakWindowOptions =
      zio.aws.opensearch.model.OffPeakWindowOptions(
        enabled.map(value => value),
        offPeakWindow.map(value => value.asEditable)
      )
    def enabled: Optional[Boolean]
    def offPeakWindow: Optional[zio.aws.opensearch.model.OffPeakWindow.ReadOnly]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getOffPeakWindow
        : ZIO[Any, AwsError, zio.aws.opensearch.model.OffPeakWindow.ReadOnly] =
      AwsError.unwrapOptionField("offPeakWindow", offPeakWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptions
  ) extends zio.aws.opensearch.model.OffPeakWindowOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val offPeakWindow
        : Optional[zio.aws.opensearch.model.OffPeakWindow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offPeakWindow())
        .map(value => zio.aws.opensearch.model.OffPeakWindow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptions
  ): zio.aws.opensearch.model.OffPeakWindowOptions.ReadOnly = new Wrapper(impl)
}
