package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OffPeakWindow(
    windowStartTime: Optional[zio.aws.opensearch.model.WindowStartTime] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.OffPeakWindow = {
    import OffPeakWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.OffPeakWindow
      .builder()
      .optionallyWith(windowStartTime.map(value => value.buildAwsValue()))(
        _.windowStartTime
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.OffPeakWindow.ReadOnly =
    zio.aws.opensearch.model.OffPeakWindow.wrap(buildAwsValue())
}
object OffPeakWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.OffPeakWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.OffPeakWindow =
      zio.aws.opensearch.model
        .OffPeakWindow(windowStartTime.map(value => value.asEditable))
    def windowStartTime
        : Optional[zio.aws.opensearch.model.WindowStartTime.ReadOnly]
    def getWindowStartTime: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.WindowStartTime.ReadOnly
    ] = AwsError.unwrapOptionField("windowStartTime", windowStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.OffPeakWindow
  ) extends zio.aws.opensearch.model.OffPeakWindow.ReadOnly {
    override val windowStartTime
        : Optional[zio.aws.opensearch.model.WindowStartTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowStartTime())
        .map(value => zio.aws.opensearch.model.WindowStartTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.OffPeakWindow
  ): zio.aws.opensearch.model.OffPeakWindow.ReadOnly = new Wrapper(impl)
}
