package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait NodeType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.NodeType
}
object NodeType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.NodeType
  ): zio.aws.opensearch.model.NodeType = value match {
    case software.amazon.awssdk.services.opensearch.model.NodeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.NodeType.DATA =>
      val r = Data
      r
    case software.amazon.awssdk.services.opensearch.model.NodeType.ULTRAWARM =>
      val r = Ultrawarm
      r
    case software.amazon.awssdk.services.opensearch.model.NodeType.MASTER =>
      val r = Master
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.NodeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeType =
      software.amazon.awssdk.services.opensearch.model.NodeType.UNKNOWN_TO_SDK_VERSION
  }
  case object Data extends zio.aws.opensearch.model.NodeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeType =
      software.amazon.awssdk.services.opensearch.model.NodeType.DATA
  }
  case object Ultrawarm extends zio.aws.opensearch.model.NodeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeType =
      software.amazon.awssdk.services.opensearch.model.NodeType.ULTRAWARM
  }
  case object Master extends zio.aws.opensearch.model.NodeType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeType =
      software.amazon.awssdk.services.opensearch.model.NodeType.MASTER
  }
}
