package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait NodeStatus {
  def unwrap: software.amazon.awssdk.services.opensearch.model.NodeStatus
}
object NodeStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.NodeStatus
  ): zio.aws.opensearch.model.NodeStatus = value match {
    case software.amazon.awssdk.services.opensearch.model.NodeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.NodeStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.opensearch.model.NodeStatus.STAND_BY =>
      val r = StandBy
      r
    case software.amazon.awssdk.services.opensearch.model.NodeStatus.NOT_AVAILABLE =>
      val r = NotAvailable
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeStatus =
      software.amazon.awssdk.services.opensearch.model.NodeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.opensearch.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeStatus =
      software.amazon.awssdk.services.opensearch.model.NodeStatus.ACTIVE
  }
  case object StandBy extends zio.aws.opensearch.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeStatus =
      software.amazon.awssdk.services.opensearch.model.NodeStatus.STAND_BY
  }
  case object NotAvailable extends zio.aws.opensearch.model.NodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.NodeStatus =
      software.amazon.awssdk.services.opensearch.model.NodeStatus.NOT_AVAILABLE
  }
}
