package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait MasterNodeStatus {
  def unwrap: software.amazon.awssdk.services.opensearch.model.MasterNodeStatus
}
object MasterNodeStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.MasterNodeStatus
  ): zio.aws.opensearch.model.MasterNodeStatus = value match {
    case software.amazon.awssdk.services.opensearch.model.MasterNodeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.MasterNodeStatus.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.opensearch.model.MasterNodeStatus.UN_AVAILABLE =>
      val r = UnAvailable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.MasterNodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.MasterNodeStatus =
      software.amazon.awssdk.services.opensearch.model.MasterNodeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Available extends zio.aws.opensearch.model.MasterNodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.MasterNodeStatus =
      software.amazon.awssdk.services.opensearch.model.MasterNodeStatus.AVAILABLE
  }
  case object UnAvailable extends zio.aws.opensearch.model.MasterNodeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.MasterNodeStatus =
      software.amazon.awssdk.services.opensearch.model.MasterNodeStatus.UN_AVAILABLE
  }
}
