package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.CloudWatchLogsLogGroupArn
import scala.jdk.CollectionConverters._
final case class LogPublishingOption(
    cloudWatchLogsLogGroupArn: Optional[CloudWatchLogsLogGroupArn] =
      Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.LogPublishingOption = {
    import LogPublishingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.LogPublishingOption
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value =>
          CloudWatchLogsLogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsLogGroupArn)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.LogPublishingOption.ReadOnly =
    zio.aws.opensearch.model.LogPublishingOption.wrap(buildAwsValue())
}
object LogPublishingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.LogPublishingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.LogPublishingOption =
      zio.aws.opensearch.model.LogPublishingOption(
        cloudWatchLogsLogGroupArn.map(value => value),
        enabled.map(value => value)
      )
    def cloudWatchLogsLogGroupArn: Optional[CloudWatchLogsLogGroupArn]
    def enabled: Optional[Boolean]
    def getCloudWatchLogsLogGroupArn
        : ZIO[Any, AwsError, CloudWatchLogsLogGroupArn] = AwsError
      .unwrapOptionField("cloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.LogPublishingOption
  ) extends zio.aws.opensearch.model.LogPublishingOption.ReadOnly {
    override val cloudWatchLogsLogGroupArn
        : Optional[CloudWatchLogsLogGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsLogGroupArn())
      .map(value =>
        zio.aws.opensearch.model.primitives.CloudWatchLogsLogGroupArn(value)
      )
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.LogPublishingOption
  ): zio.aws.opensearch.model.LogPublishingOption.ReadOnly = new Wrapper(impl)
}
