package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointsRequest(
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest = {
    import ListVpcEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ListVpcEndpointsRequest.ReadOnly =
    zio.aws.opensearch.model.ListVpcEndpointsRequest.wrap(buildAwsValue())
}
object ListVpcEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListVpcEndpointsRequest =
      zio.aws.opensearch.model
        .ListVpcEndpointsRequest(nextToken.map(value => value))
    def nextToken: Optional[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest
  ) extends zio.aws.opensearch.model.ListVpcEndpointsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest
  ): zio.aws.opensearch.model.ListVpcEndpointsRequest.ReadOnly = new Wrapper(
    impl
  )
}
