package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointsForDomainResponse(
    vpcEndpointSummaryList: Iterable[
      zio.aws.opensearch.model.VpcEndpointSummary
    ],
    nextToken: NextToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse = {
    import ListVpcEndpointsForDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse
      .builder()
      .vpcEndpointSummaryList(vpcEndpointSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .nextToken(NextToken.unwrap(nextToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse.ReadOnly =
    zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse
      .wrap(buildAwsValue())
}
object ListVpcEndpointsForDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse =
      zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse(
        vpcEndpointSummaryList.map { item =>
          item.asEditable
        },
        nextToken
      )
    def vpcEndpointSummaryList
        : List[zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly]
    def nextToken: NextToken
    def getVpcEndpointSummaryList: ZIO[Any, Nothing, List[
      zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly
    ]] = ZIO.succeed(vpcEndpointSummaryList)
    def getNextToken: ZIO[Any, Nothing, NextToken] = ZIO.succeed(nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse
  ) extends zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse.ReadOnly {
    override val vpcEndpointSummaryList
        : List[zio.aws.opensearch.model.VpcEndpointSummary.ReadOnly] = impl
      .vpcEndpointSummaryList()
      .asScala
      .map { item =>
        zio.aws.opensearch.model.VpcEndpointSummary.wrap(item)
      }
      .toList
    override val nextToken: NextToken =
      zio.aws.opensearch.model.primitives.NextToken(impl.nextToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse
  ): zio.aws.opensearch.model.ListVpcEndpointsForDomainResponse.ReadOnly =
    new Wrapper(impl)
}
