package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{NextToken, DomainName}
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointsForDomainRequest(
    domainName: DomainName,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest = {
    import ListVpcEndpointsForDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest.ReadOnly =
    zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest
      .wrap(buildAwsValue())
}
object ListVpcEndpointsForDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest =
      zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest(
        domainName,
        nextToken.map(value => value)
      )
    def domainName: DomainName
    def nextToken: Optional[NextToken]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest
  ) extends zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest
  ): zio.aws.opensearch.model.ListVpcEndpointsForDomainRequest.ReadOnly =
    new Wrapper(impl)
}
