package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointAccessResponse(
    authorizedPrincipalList: Iterable[
      zio.aws.opensearch.model.AuthorizedPrincipal
    ],
    nextToken: NextToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse = {
    import ListVpcEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse
      .builder()
      .authorizedPrincipalList(authorizedPrincipalList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .nextToken(NextToken.unwrap(nextToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListVpcEndpointAccessResponse.ReadOnly =
    zio.aws.opensearch.model.ListVpcEndpointAccessResponse.wrap(buildAwsValue())
}
object ListVpcEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListVpcEndpointAccessResponse =
      zio.aws.opensearch.model.ListVpcEndpointAccessResponse(
        authorizedPrincipalList.map { item =>
          item.asEditable
        },
        nextToken
      )
    def authorizedPrincipalList
        : List[zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly]
    def nextToken: NextToken
    def getAuthorizedPrincipalList: ZIO[Any, Nothing, List[
      zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly
    ]] = ZIO.succeed(authorizedPrincipalList)
    def getNextToken: ZIO[Any, Nothing, NextToken] = ZIO.succeed(nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse
  ) extends zio.aws.opensearch.model.ListVpcEndpointAccessResponse.ReadOnly {
    override val authorizedPrincipalList
        : List[zio.aws.opensearch.model.AuthorizedPrincipal.ReadOnly] = impl
      .authorizedPrincipalList()
      .asScala
      .map { item =>
        zio.aws.opensearch.model.AuthorizedPrincipal.wrap(item)
      }
      .toList
    override val nextToken: NextToken =
      zio.aws.opensearch.model.primitives.NextToken(impl.nextToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse
  ): zio.aws.opensearch.model.ListVpcEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
