package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{NextToken, DomainName}
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointAccessRequest(
    domainName: DomainName,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest = {
    import ListVpcEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListVpcEndpointAccessRequest.ReadOnly =
    zio.aws.opensearch.model.ListVpcEndpointAccessRequest.wrap(buildAwsValue())
}
object ListVpcEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListVpcEndpointAccessRequest =
      zio.aws.opensearch.model
        .ListVpcEndpointAccessRequest(domainName, nextToken.map(value => value))
    def domainName: DomainName
    def nextToken: Optional[NextToken]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest
  ) extends zio.aws.opensearch.model.ListVpcEndpointAccessRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest
  ): zio.aws.opensearch.model.ListVpcEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
