package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListScheduledActionsResponse(
    scheduledActions: Optional[
      Iterable[zio.aws.opensearch.model.ScheduledAction]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse = {
    import ListScheduledActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse
      .builder()
      .optionallyWith(
        scheduledActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledActions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListScheduledActionsResponse.ReadOnly =
    zio.aws.opensearch.model.ListScheduledActionsResponse.wrap(buildAwsValue())
}
object ListScheduledActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListScheduledActionsResponse =
      zio.aws.opensearch.model.ListScheduledActionsResponse(
        scheduledActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scheduledActions
        : Optional[List[zio.aws.opensearch.model.ScheduledAction.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getScheduledActions: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.ScheduledAction.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduledActions", scheduledActions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse
  ) extends zio.aws.opensearch.model.ListScheduledActionsResponse.ReadOnly {
    override val scheduledActions
        : Optional[List[zio.aws.opensearch.model.ScheduledAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.ScheduledAction.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse
  ): zio.aws.opensearch.model.ListScheduledActionsResponse.ReadOnly =
    new Wrapper(impl)
}
