package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{AvailabilityZone, InstanceRole}
import scala.jdk.CollectionConverters._
final case class InstanceTypeDetails(
    instanceType: Optional[
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = Optional.Absent,
    encryptionEnabled: Optional[Boolean] = Optional.Absent,
    cognitoEnabled: Optional[Boolean] = Optional.Absent,
    appLogsEnabled: Optional[Boolean] = Optional.Absent,
    advancedSecurityEnabled: Optional[Boolean] = Optional.Absent,
    warmEnabled: Optional[Boolean] = Optional.Absent,
    instanceRole: Optional[Iterable[InstanceRole]] = Optional.Absent,
    availabilityZones: Optional[Iterable[AvailabilityZone]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails = {
    import InstanceTypeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(encryptionEnabled.map(value => value: java.lang.Boolean))(
        _.encryptionEnabled
      )
      .optionallyWith(cognitoEnabled.map(value => value: java.lang.Boolean))(
        _.cognitoEnabled
      )
      .optionallyWith(appLogsEnabled.map(value => value: java.lang.Boolean))(
        _.appLogsEnabled
      )
      .optionallyWith(
        advancedSecurityEnabled.map(value => value: java.lang.Boolean)
      )(_.advancedSecurityEnabled)
      .optionallyWith(warmEnabled.map(value => value: java.lang.Boolean))(
        _.warmEnabled
      )
      .optionallyWith(
        instanceRole.map(value =>
          value.map { item =>
            InstanceRole.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceRole)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            AvailabilityZone.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly =
    zio.aws.opensearch.model.InstanceTypeDetails.wrap(buildAwsValue())
}
object InstanceTypeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.InstanceTypeDetails =
      zio.aws.opensearch.model.InstanceTypeDetails(
        instanceType.map(value => value),
        encryptionEnabled.map(value => value),
        cognitoEnabled.map(value => value),
        appLogsEnabled.map(value => value),
        advancedSecurityEnabled.map(value => value),
        warmEnabled.map(value => value),
        instanceRole.map(value => value),
        availabilityZones.map(value => value)
      )
    def instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType]
    def encryptionEnabled: Optional[Boolean]
    def cognitoEnabled: Optional[Boolean]
    def appLogsEnabled: Optional[Boolean]
    def advancedSecurityEnabled: Optional[Boolean]
    def warmEnabled: Optional[Boolean]
    def instanceRole: Optional[List[InstanceRole]]
    def availabilityZones: Optional[List[AvailabilityZone]]
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getEncryptionEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encryptionEnabled", encryptionEnabled)
    def getCognitoEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cognitoEnabled", cognitoEnabled)
    def getAppLogsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("appLogsEnabled", appLogsEnabled)
    def getAdvancedSecurityEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("advancedSecurityEnabled", advancedSecurityEnabled)
    def getWarmEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("warmEnabled", warmEnabled)
    def getInstanceRole: ZIO[Any, AwsError, List[InstanceRole]] =
      AwsError.unwrapOptionField("instanceRole", instanceRole)
    def getAvailabilityZones: ZIO[Any, AwsError, List[AvailabilityZone]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails
  ) extends zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly {
    override val instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.opensearch.model.OpenSearchPartitionInstanceType.wrap(value)
        )
    override val encryptionEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionEnabled())
      .map(value => value: Boolean)
    override val cognitoEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cognitoEnabled())
      .map(value => value: Boolean)
    override val appLogsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.appLogsEnabled())
      .map(value => value: Boolean)
    override val advancedSecurityEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedSecurityEnabled())
        .map(value => value: Boolean)
    override val warmEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.warmEnabled())
      .map(value => value: Boolean)
    override val instanceRole: Optional[List[InstanceRole]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRole())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.primitives.InstanceRole(item)
          }.toList
        )
    override val availabilityZones: Optional[List[AvailabilityZone]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.primitives.AvailabilityZone(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails
  ): zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly = new Wrapper(impl)
}
