package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnvironmentInfo(
    availabilityZoneInformation: Optional[
      Iterable[zio.aws.opensearch.model.AvailabilityZoneInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.EnvironmentInfo = {
    import EnvironmentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.EnvironmentInfo
      .builder()
      .optionallyWith(
        availabilityZoneInformation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZoneInformation)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.EnvironmentInfo.ReadOnly =
    zio.aws.opensearch.model.EnvironmentInfo.wrap(buildAwsValue())
}
object EnvironmentInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.EnvironmentInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.EnvironmentInfo =
      zio.aws.opensearch.model.EnvironmentInfo(
        availabilityZoneInformation.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZoneInformation
        : Optional[List[zio.aws.opensearch.model.AvailabilityZoneInfo.ReadOnly]]
    def getAvailabilityZoneInformation: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.AvailabilityZoneInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "availabilityZoneInformation",
      availabilityZoneInformation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.EnvironmentInfo
  ) extends zio.aws.opensearch.model.EnvironmentInfo.ReadOnly {
    override val availabilityZoneInformation: Optional[
      List[zio.aws.opensearch.model.AvailabilityZoneInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneInformation())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.AvailabilityZoneInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.EnvironmentInfo
  ): zio.aws.opensearch.model.EnvironmentInfo.ReadOnly = new Wrapper(impl)
}
