package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.GUID
import scala.jdk.CollectionConverters._
final case class DryRunProgressStatus(
    dryRunId: GUID,
    dryRunStatus: String,
    creationDate: String,
    updateDate: String,
    validationFailures: Optional[
      Iterable[zio.aws.opensearch.model.ValidationFailure]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DryRunProgressStatus = {
    import DryRunProgressStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DryRunProgressStatus
      .builder()
      .dryRunId(GUID.unwrap(dryRunId): java.lang.String)
      .dryRunStatus(dryRunStatus: java.lang.String)
      .creationDate(creationDate: java.lang.String)
      .updateDate(updateDate: java.lang.String)
      .optionallyWith(
        validationFailures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationFailures)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DryRunProgressStatus.ReadOnly =
    zio.aws.opensearch.model.DryRunProgressStatus.wrap(buildAwsValue())
}
object DryRunProgressStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DryRunProgressStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DryRunProgressStatus =
      zio.aws.opensearch.model.DryRunProgressStatus(
        dryRunId,
        dryRunStatus,
        creationDate,
        updateDate,
        validationFailures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRunId: GUID
    def dryRunStatus: String
    def creationDate: String
    def updateDate: String
    def validationFailures
        : Optional[List[zio.aws.opensearch.model.ValidationFailure.ReadOnly]]
    def getDryRunId: ZIO[Any, Nothing, GUID] = ZIO.succeed(dryRunId)
    def getDryRunStatus: ZIO[Any, Nothing, String] = ZIO.succeed(dryRunStatus)
    def getCreationDate: ZIO[Any, Nothing, String] = ZIO.succeed(creationDate)
    def getUpdateDate: ZIO[Any, Nothing, String] = ZIO.succeed(updateDate)
    def getValidationFailures: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.ValidationFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("validationFailures", validationFailures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DryRunProgressStatus
  ) extends zio.aws.opensearch.model.DryRunProgressStatus.ReadOnly {
    override val dryRunId: GUID =
      zio.aws.opensearch.model.primitives.GUID(impl.dryRunId())
    override val dryRunStatus: String = impl.dryRunStatus(): String
    override val creationDate: String = impl.creationDate(): String
    override val updateDate: String = impl.updateDate(): String
    override val validationFailures
        : Optional[List[zio.aws.opensearch.model.ValidationFailure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationFailures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.ValidationFailure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DryRunProgressStatus
  ): zio.aws.opensearch.model.DryRunProgressStatus.ReadOnly = new Wrapper(impl)
}
