package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait DryRunMode {
  def unwrap: software.amazon.awssdk.services.opensearch.model.DryRunMode
}
object DryRunMode {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.DryRunMode
  ): zio.aws.opensearch.model.DryRunMode = value match {
    case software.amazon.awssdk.services.opensearch.model.DryRunMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.DryRunMode.BASIC =>
      val r = Basic
      r
    case software.amazon.awssdk.services.opensearch.model.DryRunMode.VERBOSE =>
      val r = Verbose
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.DryRunMode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DryRunMode =
      software.amazon.awssdk.services.opensearch.model.DryRunMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Basic extends zio.aws.opensearch.model.DryRunMode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DryRunMode =
      software.amazon.awssdk.services.opensearch.model.DryRunMode.BASIC
  }
  case object Verbose extends zio.aws.opensearch.model.DryRunMode {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DryRunMode =
      software.amazon.awssdk.services.opensearch.model.DryRunMode.VERBOSE
  }
}
