package zio.aws.opensearch.model
import scala.jdk.CollectionConverters._
sealed trait DomainState {
  def unwrap: software.amazon.awssdk.services.opensearch.model.DomainState
}
object DomainState {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.DomainState
  ): zio.aws.opensearch.model.DomainState = value match {
    case software.amazon.awssdk.services.opensearch.model.DomainState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.DomainState.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.opensearch.model.DomainState.PROCESSING =>
      val r = Processing
      r
    case software.amazon.awssdk.services.opensearch.model.DomainState.NOT_AVAILABLE =>
      val r = NotAvailable
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.DomainState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainState =
      software.amazon.awssdk.services.opensearch.model.DomainState.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.opensearch.model.DomainState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainState =
      software.amazon.awssdk.services.opensearch.model.DomainState.ACTIVE
  }
  case object Processing extends zio.aws.opensearch.model.DomainState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainState =
      software.amazon.awssdk.services.opensearch.model.DomainState.PROCESSING
  }
  case object NotAvailable extends zio.aws.opensearch.model.DomainState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DomainState =
      software.amazon.awssdk.services.opensearch.model.DomainState.NOT_AVAILABLE
  }
}
