package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{
  VolumeSize,
  StorageTypeName,
  AvailabilityZone,
  NodeId
}
import scala.jdk.CollectionConverters._
final case class DomainNodesStatus(
    nodeId: Optional[NodeId] = Optional.Absent,
    nodeType: Optional[zio.aws.opensearch.model.NodeType] = Optional.Absent,
    availabilityZone: Optional[AvailabilityZone] = Optional.Absent,
    instanceType: Optional[
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = Optional.Absent,
    nodeStatus: Optional[zio.aws.opensearch.model.NodeStatus] = Optional.Absent,
    storageType: Optional[StorageTypeName] = Optional.Absent,
    storageVolumeType: Optional[zio.aws.opensearch.model.VolumeType] =
      Optional.Absent,
    storageSize: Optional[VolumeSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DomainNodesStatus = {
    import DomainNodesStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DomainNodesStatus
      .builder()
      .optionallyWith(
        nodeId.map(value => NodeId.unwrap(value): java.lang.String)
      )(_.nodeId)
      .optionallyWith(nodeType.map(value => value.unwrap))(_.nodeType)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZone.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(nodeStatus.map(value => value.unwrap))(_.nodeStatus)
      .optionallyWith(
        storageType.map(value =>
          StorageTypeName.unwrap(value): java.lang.String
        )
      )(_.storageType)
      .optionallyWith(storageVolumeType.map(value => value.unwrap))(
        _.storageVolumeType
      )
      .optionallyWith(
        storageSize.map(value => VolumeSize.unwrap(value): java.lang.String)
      )(_.storageSize)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DomainNodesStatus.ReadOnly =
    zio.aws.opensearch.model.DomainNodesStatus.wrap(buildAwsValue())
}
object DomainNodesStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DomainNodesStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DomainNodesStatus =
      zio.aws.opensearch.model.DomainNodesStatus(
        nodeId.map(value => value),
        nodeType.map(value => value),
        availabilityZone.map(value => value),
        instanceType.map(value => value),
        nodeStatus.map(value => value),
        storageType.map(value => value),
        storageVolumeType.map(value => value),
        storageSize.map(value => value)
      )
    def nodeId: Optional[NodeId]
    def nodeType: Optional[zio.aws.opensearch.model.NodeType]
    def availabilityZone: Optional[AvailabilityZone]
    def instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType]
    def nodeStatus: Optional[zio.aws.opensearch.model.NodeStatus]
    def storageType: Optional[StorageTypeName]
    def storageVolumeType: Optional[zio.aws.opensearch.model.VolumeType]
    def storageSize: Optional[VolumeSize]
    def getNodeId: ZIO[Any, AwsError, NodeId] =
      AwsError.unwrapOptionField("nodeId", nodeId)
    def getNodeType: ZIO[Any, AwsError, zio.aws.opensearch.model.NodeType] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZone] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getNodeStatus: ZIO[Any, AwsError, zio.aws.opensearch.model.NodeStatus] =
      AwsError.unwrapOptionField("nodeStatus", nodeStatus)
    def getStorageType: ZIO[Any, AwsError, StorageTypeName] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getStorageVolumeType
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VolumeType] =
      AwsError.unwrapOptionField("storageVolumeType", storageVolumeType)
    def getStorageSize: ZIO[Any, AwsError, VolumeSize] =
      AwsError.unwrapOptionField("storageSize", storageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DomainNodesStatus
  ) extends zio.aws.opensearch.model.DomainNodesStatus.ReadOnly {
    override val nodeId: Optional[NodeId] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeId())
      .map(value => zio.aws.opensearch.model.primitives.NodeId(value))
    override val nodeType: Optional[zio.aws.opensearch.model.NodeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeType())
        .map(value => zio.aws.opensearch.model.NodeType.wrap(value))
    override val availabilityZone: Optional[AvailabilityZone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.opensearch.model.primitives.AvailabilityZone(value)
        )
    override val instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.opensearch.model.OpenSearchPartitionInstanceType.wrap(value)
        )
    override val nodeStatus: Optional[zio.aws.opensearch.model.NodeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeStatus())
        .map(value => zio.aws.opensearch.model.NodeStatus.wrap(value))
    override val storageType: Optional[StorageTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => zio.aws.opensearch.model.primitives.StorageTypeName(value))
    override val storageVolumeType
        : Optional[zio.aws.opensearch.model.VolumeType] = zio.aws.core.internal
      .optionalFromNullable(impl.storageVolumeType())
      .map(value => zio.aws.opensearch.model.VolumeType.wrap(value))
    override val storageSize: Optional[VolumeSize] = zio.aws.core.internal
      .optionalFromNullable(impl.storageSize())
      .map(value => zio.aws.opensearch.model.primitives.VolumeSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DomainNodesStatus
  ): zio.aws.opensearch.model.DomainNodesStatus.ReadOnly = new Wrapper(impl)
}
